/***************************************************************
 *                    simula.plus@cemes.fr                     *
 *	             GNU/linux version 3.0.0                   *
 *            software under General Public License            *
 ***************************************************************
 * copyright © 2006,2007,2008,2009,2012 COLLARD Christophe
 * copyright © 2006,2007,2008,2009,2012 Centre National de la Recherche Scientifique
 * copyright © 2006,2007,2008,2009 Arts et Métiers ParisTech
 * copyright © 2006,2007 Université de Valenciennes et du Hainaut-Cambrésis
 * copyright © 2006,2007,2008,2009 Laboratoire de Physique et Mécanique des Matériaux (LPMM - CNRS)
 * copyright © 2006,2007 Laboratoire de Mathématiques et ses Applications de Valenciennes (LAMAV)
 * copyright © 2012 Centre d'Elaboration de Matériaux et d'Etudes Structurales (CEMES - CNRS)
 ***************************************************************/

/*
    cubic tensors-tests belongs to Materials Object Libraries (MateriOL++)
    MateriOL++ is part of Simula+

    Simula+ is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Simula+ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Simula+; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef __cplusplus
#error Must use C++ for the type cubic tensors test
#endif

#ifndef __cubic_tensors_test_hpp
#define __cubic_tensors_test_hpp


#ifndef __iostream
#include <iostream>
#endif

#ifndef __stdio_h
#include <stdio.h>
#endif

#ifndef __stdlib_h
#include <stdlib.h>
#endif

#ifndef __colors_hpp
#include "colors.hpp"
#endif

#ifndef __parameters_h
#include "parameters.h"
#endif

#ifndef __vectors_hpp
#include "MOL++/vectors.hpp"
#endif

#ifndef __matrix_hpp
#include "MOL++/matrix.hpp"
#endif

#ifndef __tensors4_hpp
#include "MOL++/tensors4.hpp"
#endif

#ifndef __isotropic_elasticity_tensors_hpp
#include "MateriOL++/isotropic elasticity tensors.hpp"
#endif

#ifndef __cubic_tensors_hpp
#include "MateriOL++/cubic tensors.hpp"
#endif

#ifndef __affiche_hpp
#include "tests/affiche.hpp"
#endif

using namespace materiol;


//================================
int test_cubic_tensor (int detail)
//================================
{
  bool result = true;

  if (detail < 0) 
    { cout << "============================================================== \n";
      cout << blue << "                   cubic tensor test skipped" << reset;
      cout << "============================================================== \n";
      return result;
    }

  long double lambda=60000, mu=40000;
  isotropic_elasticity_tensor<long double> C;
  C.Lame(lambda);
  C.Shear(mu);
  cubic_tensor<long double> Co (lambda+2*mu, mu,lambda);
  if (detail) affiche ("cubic tensor for isotropic materials", Co==C);
  else result *= (Co==C);

  long double C11=141600, C12=127400, C44=94200;
  cubic_tensor<long double> Cn(C11,C44,C12, "cubic tensor");
  tensor4<long double> T4(3);
  T4(1,1,1,1) = T4(2,2,2,2) = T4(3,3,3,3) = C11;
  T4(1,2,1,2) = T4(1,2,2,1) = T4(2,1,1,2) = T4(2,1,2,1) = T4(1,3,1,3) = T4(1,3,3,1) = T4(3,1,1,3) = T4(3,1,3,1) = T4(2,3,2,3) = T4(2,3,3,2) = T4(3,2,2,3) = T4(3,2,3,2) = C44;
  T4(1,1,2,2) = T4(2,2,1,1) = T4(1,1,3,3) = T4(3,3,1,1) = T4(2,2,3,3) = T4(3,3,2,2) = C12;

  vector<long double> v(3);
  v[1] = C11;
  v[2] = C44;
  v[3] = C12;
  cubic_tensor<long double> Cv(v, "cubic tensor");
  if (detail) affiche("constructors", T4==Cn && Cv==Cn);
  else result *= (T4==Cn && Cv==Cn);

  bool test = true;
  tensor4<long double> T;
  T = Cn;
  for (int i=1; i<=3; i++)
    for (int j=1; j<=3; j++)
      for (int k=1; k<=3; k++)
	for (int l=1; l<=3; l++)
	  test *= (T(i,j,k,l) == Cn(i,j,k,l));
  if (detail) affiche ("cast conversion cubic_tensor -> tensor4", test);
  else result *= (test);

  cubic_tensor<long double> Ci;
  Ci = cubic_tensor<long double> (T);
  if (detail) affiche ("cast conversion tensor4 -> cubic_tensor", Cn==Ci);
  else result *= (Cn==Ci);

  if (detail) affiche ("elastic constants", Cn.elastic_constants() == v);
  else result *= (Cn.elastic_constants() == v);

  tensor4<long double> Id(3);
  Id = Id4s<long double> (3);
  if (detail) affiche ("inv", (Cn||Cn.inv()) == Id && (Cn.inv()||Cn) == Id);
  else result *= ((Cn||Cn.inv()) == Id && (Cn.inv()||Cn) == Id);

  cout << endl;

  cout << "============================================================== \n";
  if (result) cout << green << "                   cubic tensor test passed" << reset;
  else cout << red << "                   cubic tensor test failed" << reset;
  cout << "============================================================== \n";

  return result;
}


#endif
